/*
 * Decompiled with CFR 0.152.
 */
package Krasnodar.rockstarnew.systems.modules.modules.visuals;

import Krasnodar.rockstarnew.systems.event.EventListener;
import Krasnodar.rockstarnew.systems.event.impl.game.WorldChangeEvent;
import Krasnodar.rockstarnew.systems.event.impl.render.Render3DEvent;
import Krasnodar.rockstarnew.systems.modules.api.ModuleCategory;
import Krasnodar.rockstarnew.systems.modules.api.ModuleInfo;
import Krasnodar.rockstarnew.systems.modules.impl.BaseModule;
import Krasnodar.rockstarnew.systems.setting.settings.SelectSetting;
import Krasnodar.rockstarnew.utility.colors.ColorRGBA;
import Krasnodar.rockstarnew.utility.colors.Colors;
import Krasnodar.rockstarnew.utility.game.EntityUtility;
import Krasnodar.rockstarnew.utility.render.Draw3DUtility;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import net.minecraft.class_10142;
import net.minecraft.class_10156;
import net.minecraft.class_1922;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2818;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_9801;

@ModuleInfo(name="XRay", category=ModuleCategory.VISUALS, desc="\u041f\u043e\u0434\u0441\u0432\u0435\u0447\u0438\u0432\u0430\u0435\u0442 \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d\u043d\u044b\u0435 \u0440\u0443\u0434\u044b")
public class XRay
extends BaseModule {
    private final Set<class_2338> cachedBlocks = ConcurrentHashMap.newKeySet();
    private final SelectSetting blocks = new SelectSetting(this, "\u0420\u0443\u0434\u044b");
    public final SelectSetting.Value diamondOre = new SelectSetting.Value(this.blocks, "\u0410\u043b\u043c\u0430\u0437\u043d\u0430\u044f \u0440\u0443\u0434\u0430");
    public final SelectSetting.Value ironOre = new SelectSetting.Value(this.blocks, "\u0416\u0435\u043b\u0435\u0437\u043d\u0430\u044f \u0440\u0443\u0434\u0430");
    public final SelectSetting.Value goldOre = new SelectSetting.Value(this.blocks, "\u0417\u043e\u043b\u043e\u0442\u0430\u044f \u0440\u0443\u0434\u0430");
    public final SelectSetting.Value ancientOre = new SelectSetting.Value(this.blocks, "\u041e\u0431\u043b\u043e\u043c\u043a\u0438");
    public final SelectSetting.Value lapisOre = new SelectSetting.Value(this.blocks, "\u041b\u0430\u0437\u0443\u0440\u0438\u0442\u043e\u0432\u0430\u044f \u0440\u0443\u0434\u0430");
    private int diamonds = 0;
    private int ancient = 0;
    private int gold = 0;
    private int lapis = 0;
    private final EventListener<Render3DEvent> onHudRenderEvent = event -> {
        if (XRay.mc.field_1687 != null && XRay.mc.field_1724 != null) {
            class_4587 matrices = event.getMatrices();
            class_4184 camera = XRay.mc.field_1773.method_19418();
            class_243 cameraPos = camera.method_19326();
            matrices.method_22903();
            matrices.method_22904(-cameraPos.method_10216(), -cameraPos.method_10214(), -cameraPos.method_10215());
            RenderSystem.enableBlend();
            RenderSystem.disableDepthTest();
            RenderSystem.disableCull();
            RenderSystem.blendFunc((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE);
            RenderSystem.lineWidth((float)10.0f);
            RenderSystem.setShader((class_10156)class_10142.field_53876);
            double maxDistSq = 999999.0;
            class_287 buffer = class_289.method_1348().method_60827(class_293.class_5596.field_27382, class_290.field_1576);
            for (class_2338 pos : this.cachedBlocks) {
                if (XRay.mc.field_1724.method_5707(pos.method_46558()) > maxDistSq) continue;
                class_238 boundingBox = this.getBoundingBox(pos);
                class_2248 block = XRay.mc.field_1687.method_8320(pos).method_26204();
                Draw3DUtility.renderFilledBox(event.getMatrices(), buffer, boundingBox, this.getBlockColor(block).withAlpha(30.0f));
            }
            class_9801 builtBuffer = buffer.method_60794();
            if (builtBuffer != null) {
                class_286.method_43433((class_9801)builtBuffer);
            }
            RenderSystem.enableCull();
            RenderSystem.enableDepthTest();
            RenderSystem.disableBlend();
            matrices.method_22909();
        }
    };
    private final EventListener<WorldChangeEvent> onWorldChange = event -> this.cachedBlocks.clear();

    public void scanChunk(class_2818 chunk) {
        if (XRay.mc.field_1687 != null && chunk != null) {
            int chunkX = chunk.method_12004().method_8326();
            int chunkZ = chunk.method_12004().method_8328();
            for (int x = 0; x < 16; ++x) {
                for (int y = XRay.mc.field_1687.method_31607(); y < XRay.mc.field_1687.method_31600(); ++y) {
                    for (int z = 0; z < 16; ++z) {
                        class_2338 pos = new class_2338(chunkX + x, y, chunkZ + z);
                        class_2680 state = chunk.method_8320(pos);
                        if (state.method_26215() || !this.isBlockEnabled(state.method_26204())) continue;
                        this.cachedBlocks.add(pos);
                    }
                }
            }
        }
    }

    @Override
    public void onEnable() {
        if (EntityUtility.isInGame()) {
            super.onEnable();
        }
    }

    @Override
    public void onDisable() {
        this.cachedBlocks.clear();
        this.diamonds = 0;
        this.ancient = 0;
        this.gold = 0;
        this.lapis = 0;
        super.onDisable();
    }

    @Override
    public void tick() {
        this.countBlocks();
        this.removeInvalidBlocks();
        super.tick();
    }

    private void removeInvalidBlocks() {
        this.cachedBlocks.removeIf(pos -> !this.isInRenderDistance((class_2338)pos));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void countBlocks() {
        int d = 0;
        int a = 0;
        int g = 0;
        int l = 0;
        Set<class_2338> set = this.cachedBlocks;
        synchronized (set) {
            for (class_2338 pos : this.cachedBlocks) {
                class_2248 block = XRay.mc.field_1687.method_8320(pos).method_26204();
                if (block == class_2246.field_10442 && this.diamondOre.isSelected()) {
                    ++d;
                    continue;
                }
                if (block == class_2246.field_22109) {
                    ++a;
                    continue;
                }
                if (block == class_2246.field_10571 && this.goldOre.isSelected()) {
                    ++g;
                    continue;
                }
                if (block != class_2246.field_10090 || !this.lapisOre.isSelected()) continue;
                ++l;
            }
        }
        this.diamonds = d;
        this.ancient = a;
        this.gold = g;
        this.lapis = l;
    }

    private ColorRGBA getBlockColor(class_2248 block) {
        if (block == class_2246.field_22109) {
            return new ColorRGBA(255.0f, 131.0f, 54.0f);
        }
        if (block == class_2246.field_10442) {
            return new ColorRGBA(121.0f, 54.0f, 255.0f);
        }
        if (block == class_2246.field_10571) {
            return new ColorRGBA(255.0f, 215.0f, 0.0f);
        }
        return block == class_2246.field_10090 ? new ColorRGBA(0.0f, 71.0f, 179.0f) : Colors.WHITE;
    }

    private boolean isInRenderDistance(class_2338 pos) {
        return true;
    }

    private class_238 getBoundingBox(class_2338 blockEntity) {
        class_2680 blockState = XRay.mc.field_1687.method_8320(blockEntity);
        class_265 shape = blockState.method_26218((class_1922)XRay.mc.field_1687, blockEntity);
        return shape.method_1110() ? new class_238(0.0, 0.0, 0.0, 1.0, 1.0, 1.0).method_996(blockEntity) : shape.method_1107().method_996(blockEntity);
    }

    public boolean isBlockEnabled(class_2248 block) {
        if (block == class_2246.field_10442 && this.diamondOre.isSelected()) {
            return true;
        }
        if (block == class_2246.field_10212 && this.ironOre.isSelected()) {
            return true;
        }
        if (block == class_2246.field_10571 && this.goldOre.isSelected()) {
            return true;
        }
        return block == class_2246.field_10090 && this.lapisOre.isSelected() ? true : block == class_2246.field_22109 && this.ancientOre.isSelected();
    }

    @Generated
    public Set<class_2338> getCachedBlocks() {
        return this.cachedBlocks;
    }

    @Generated
    public int getDiamonds() {
        return this.diamonds;
    }

    @Generated
    public int getAncient() {
        return this.ancient;
    }

    @Generated
    public int getGold() {
        return this.gold;
    }

    @Generated
    public int getLapis() {
        return this.lapis;
    }
}

